import Foundation

struct Constants {
    struct HealthKit {
        static let heartRateIdentifier = "com.lifeclock.app.heartrate"
        static let stepsIdentifier = "com.lifeclock.app.steps"
        static let sleepIdentifier = "com.lifeclock.app.sleep"
    }
    
    
    struct UserDefaults {
        static let lastHealthDataSync = "lastHealthDataSync"
        static let userBirthDate = "userBirthDate"
        static let predictionHistory = "predictionHistory"
    }
    
    struct Predictions {
        static let minimumLifeExpectancy: Double = 50.0
        static let maximumLifeExpectancy: Double = 120.0
        static let baseLifeExpectancy: Double = 78.0
    }
}